/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer.builtin;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_10017;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public abstract class BlockAndItemGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    public BlockAndItemGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    protected abstract List<RenderData<R>> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public abstract void addRenderData(T var1, @Nullable O var2, R var3, float var4);

    @Override
    public void addPerBoneRender(RenderPassInfo<R> renderPassInfo, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        if (!renderPassInfo.willRender()) {
            return;
        }
        R renderState = renderPassInfo.renderState();
        BakedGeoModel model = renderPassInfo.model();
        for (RenderData<R> renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData<R> renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        Either<class_1799, class_2680> renderObject = renderData.retrievalFunction().apply(bone, renderState);
        renderObject.ifLeft(stack -> {
            if (!stack.method_7960()) {
                consumer.accept(bone, (renderPassInfo, bone2, renderTasks) -> this.submitItemStackRender(renderPassInfo.poseStack(), bone2, (class_1799)stack, renderData.displayContext, renderPassInfo.renderState(), renderTasks, renderPassInfo.cameraState(), renderPassInfo.packedLight(), renderPassInfo.packedOverlay(), renderPassInfo.renderColor()));
            }
        }).ifRight(blockState -> {
            if (!blockState.method_26215()) {
                consumer.accept(bone, (renderPassInfo, bone2, renderTasks) -> this.submitBlockRender(renderPassInfo.poseStack(), bone2, (class_2680)blockState, renderPassInfo.renderState(), renderTasks, renderPassInfo.cameraState(), renderPassInfo.packedLight(), renderPassInfo.packedOverlay(), renderPassInfo.renderColor()));
            }
        });
    }

    protected void submitItemStackRender(class_4587 poseStack, GeoBone bone, class_1799 stack, class_811 displayContext, R renderState, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        class_10444 stackRenderState = new class_10444();
        class_310 mc = class_310.method_1551();
        mc.method_65386().method_65598(stackRenderState, stack, displayContext, (class_1937)mc.field_1687, null, (int)renderState.getOrDefaultGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, 0L).longValue() + displayContext.ordinal());
        stackRenderState.method_65604(poseStack, renderTasks, packedLight, class_4608.field_21444, 0);
    }

    protected void submitBlockRender(class_4587 poseStack, GeoBone bone, class_2680 state, R renderState, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        int n;
        poseStack.method_22903();
        poseStack.method_46416(-0.25f, -0.25f, -0.25f);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        if (renderState instanceof class_10017) {
            class_10017 entityState = (class_10017)renderState;
            n = entityState.field_61821;
        } else {
            n = 0;
        }
        renderTasks.method_73481(poseStack, state, packedLight, class_4608.field_21444, n);
        poseStack.method_22909();
    }

    public record RenderData<R extends GeoRenderState>(String boneName, class_811 displayContext, BiFunction<GeoBone, R, Either<class_1799, class_2680>> retrievalFunction) {
    }
}

